/*
 * (C) 2003-2006 Gabest
 * (C) 2006-2015 see Authors.txt
 *
 * This file is part of MPC-BE.
 *
 * MPC-BE is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * MPC-BE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#pragma once

#ifndef MPC_GUID_ENTRY
	#define MPC_GUID_ENTRY(name, l, w1, w2, b1, b2, b3, b4, b5, b6, b7, b8) \
	DEFINE_GUID(name, l, w1, w2, b1, b2, b3, b4, b5, b6, b7, b8);
#endif


#define WAVE_FORMAT_DOLBY_AC3 0x2000
// {00002000-0000-0010-8000-00aa00389b71}
MPC_GUID_ENTRY(MEDIASUBTYPE_WAVE_DOLBY_AC3,
			WAVE_FORMAT_DOLBY_AC3, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// Be compatible with 3ivx

#define WAVE_FORMAT_LATM_AAC 0x01FF
// {000001FF-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_LATM_AAC,
			WAVE_FORMAT_LATM_AAC, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {53544441-0000-0010-8000-00AA00389B71} AAC-ADTS LAVF/LAVC specific
MPC_GUID_ENTRY(MEDIASUBTYPE_AAC_ADTS,
			mmioFOURCC('A','D','T','S'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// ... and also compatible with nero
// btw, older nero parsers use a lower-case fourcc, newer upper-case (why can't it just offer both?)
// {4134504D-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_MP4A,
			0x4134504D, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {6134706D-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_mp4a,
			0x6134706D, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {00000055-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_MP3,
			0x00000055, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

#define WAVE_FORMAT_FLAC 0xF1AC
// {0000F1AC-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_FLAC,
			WAVE_FORMAT_FLAC, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {1541C5C0-CDDF-477d-BC0A-86F8AE7F8354}
MPC_GUID_ENTRY(MEDIASUBTYPE_FLAC_FRAMED,
			0x1541c5c0, 0xcddf, 0x477d, 0xbc, 0x0a, 0x86, 0xf8, 0xae, 0x7f, 0x83, 0x54)

// {B82196E9-1B3F-4796-A636-46239087B38E} dsfTAKsource specific
MPC_GUID_ENTRY(MEDIASUBTYPE_TAK,
			0xB82196E9, 0x1B3F, 0x4796, 0xA6, 0x36, 0x46, 0x23, 0x90, 0x87, 0xB3, 0x8E)

#define WAVE_FORMAT_TTA1 0x77A1
// {000077A1-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_TTA1,
			WAVE_FORMAT_TTA1, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {6E726873-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_Shorten,
			0x6E726873, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

#define WAVE_FORMAT_WAVPACK4 0x5756
// {00005756-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_WAVPACK4,
			WAVE_FORMAT_WAVPACK4, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {B8CBBAD8-AA1A-4cea-B95E-730041A55EF0}
MPC_GUID_ENTRY(MEDIASUBTYPE_WavpackHybrid,
			0xb8cbbad8, 0xaa1a, 0x4cea, 0xb9, 0x5e, 0x73, 0x00, 0x41, 0xa5, 0x5e, 0xf0)

// {000000FE-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_AMR,
			0x000000FE, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {726D6173-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_SAMR,
			0x726D6173, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {62776173-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_SAWB,
			0x62776173, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

MPC_GUID_ENTRY(MEDIASUBTYPE_VP70,
			0x30375056, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {30385056-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_VP80,
			0x30385056, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {30395056-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_VP90,
			0x30395056, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {34616D69-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_IMA4,
			0x34616D69, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {DA5B82EE-6BD2-426f-BF1E-30112DA78AE1}
MPC_GUID_ENTRY(MEDIASUBTYPE_SVCD_SUBPICTURE,
			0xda5b82ee, 0x6bd2, 0x426f, 0xbf, 0x1e, 0x30, 0x11, 0x2d, 0xa7, 0x8a, 0xe1)

// {7B57308F-5154-4c36-B903-52FE76E184FC}
MPC_GUID_ENTRY(MEDIASUBTYPE_CVD_SUBPICTURE,
			0x7b57308f, 0x5154, 0x4c36, 0xb9, 0x03, 0x52, 0xfe, 0x76, 0xe1, 0x84, 0xfc)

// {0E3A2342-F6E2-4c91-BDAE-87C71EAD0D63}
MPC_GUID_ENTRY(MEDIASUBTYPE_MPEG2_PVA,
			0x0e3a2342, 0xf6e2, 0x4c91, 0xbd, 0xae, 0x87, 0xc7, 0x1e, 0xad, 0x0d, 0x63)


// DirectShowMedia

// {5E9C9EE0-2E4A-4f22-9906-7BBBB75AA2B6}
MPC_GUID_ENTRY(MEDIASUBTYPE_DirectShowMedia,
			0x5e9c9ee0, 0x2e4a, 0x4f22, 0x99, 0x06, 0x7b, 0xbb, 0xb7, 0x5a, 0xa2, 0xb6)


// Dirac

// {A29DA00F-A22B-40ea-98DE-2F7FECADA5DE}
MPC_GUID_ENTRY(MEDIASUBTYPE_Dirac,
			0xa29da00f, 0xa22b, 0x40ea, 0x98, 0xde, 0x2f, 0x7f, 0xec, 0xad, 0xa5, 0xde)

// {64726376-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_DiracVideo,
			0x64726376, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {D2667A7E-4055-4244-A65F-DDDDF2B74BD7}
MPC_GUID_ENTRY(FORMAT_DiracVideoInfo,
			0xd2667a7e, 0x4055, 0x4244, 0xa6, 0x5f, 0xdd, 0xdd, 0xf2, 0xb7, 0x4b, 0xd7)

// {63617264-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_DRAC,
			0x63617264, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {434C4C43-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_CLLC,
			0x434C4C43, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)


// MP4

// {08E22ADA-B715-45ed-9D20-7B87750301D4}
MPC_GUID_ENTRY(MEDIASUBTYPE_MP4,
			0x08e22ada, 0xb715, 0x45ed, 0x9d, 0x20, 0x7b, 0x87, 0x75, 0x03, 0x01, 0xd4)


// FLV

// {F2FAC0F1-3852-4670-AAC0-9051D400AC54}
MPC_GUID_ENTRY(MEDIASUBTYPE_FLV,
			0xf2fac0f1, 0x3852, 0x4670, 0xaa, 0xc0, 0x90, 0x51, 0xd4, 0x00, 0xac, 0x54)

// {31564C46-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_FLV1,
			0x31564C46, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {31766C66-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_flv1,
			0x31766C66, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {34564C46-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_FLV4,
			0x34564C46, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {34766C66-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_flv4,
			0x34766C66, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {30335056-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_VP30,
			0x30335056, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {31335056-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_VP31,
			0x31335056, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {30355056-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_VP50,
			0x30355056, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {30357076-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_vp50,
			0x30357076, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {30365056-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_VP60,
			0x30365056, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {30367076-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_vp60,
			0x30367076, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {31365056-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_VP61,
			0x31365056, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {31367076-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_vp61,
			0x31367076, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {32365056-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_VP62,
			0x32365056, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {32367076-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_vp62,
			0x32367076, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {41365056-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_VP6A,
			0x41365056, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {61367076-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_vp6a,
			0x61367076, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {46365056-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_VP6F,
			0x46365056, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {66367076-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_vp6f,
			0x66367076, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)


// HEVC/H265

// {43564548-0000-0010-8000-00AA00389B71} HEVC
MPC_GUID_ENTRY(MEDIASUBTYPE_HEVC,
			0x43564548, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {31435648-0000-0010-8000-00AA00389B71} HVC1
MPC_GUID_ENTRY(MEDIASUBTYPE_HVC1,
			0x31435648, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {31394D48-0000-0010-8000-00AA00389B71} HEVC HM9.1
MPC_GUID_ENTRY(MEDIASUBTYPE_HM91,
			0x31394D48, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

//{30314D48-0000-0010-8000-00AA00389B71} HEVC HM10.0
MPC_GUID_ENTRY(MEDIASUBTYPE_HM10,
			0x30314D48, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

//{32314D48-0000-0010-8000-00AA00389B71} HEVC HM12.0
MPC_GUID_ENTRY(MEDIASUBTYPE_HM12,
			0x32314D48, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)


// RealMedia

// {57428EC6-C2B2-44a2-AA9C-28F0B6A5C48E}
MPC_GUID_ENTRY(MEDIASUBTYPE_RealMedia,
			0x57428ec6, 0xc2b2, 0x44a2, 0xaa, 0x9c, 0x28, 0xf0, 0xb6, 0xa5, 0xc4, 0x8e)

// {30315652-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_RV10,
			0x30315652, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {30325652-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_RV20,
			0x30325652, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {30335652-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_RV30,
			0x30335652, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {30345652-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_RV40,
			0x30345652, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {31345652-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_RV41,
			0x31345652, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

#define WAVE_FORMAT_14_4	0x2002
#define WAVE_FORMAT_28_8	0x2003
#define WAVE_FORMAT_ATRC	0x0270 //WAVE_FORMAT_SONY_SCX,
#define WAVE_FORMAT_COOK	0x2004
#define WAVE_FORMAT_DNET	0x2005
#define WAVE_FORMAT_RAAC	0x2006
#define WAVE_FORMAT_RACP	0x2007
#define WAVE_FORMAT_SIPR	0x0130 //WAVE_FORMAT_SIPROLAB_ACEPLNET,

// {345f3431-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_14_4,
			0x345f3431, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {385f3832-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_28_8,
			0x385f3832, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {43525441-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_ATRC,
			0x43525441, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {00000270-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_ATRAC3,
			WAVE_FORMAT_ATRC, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {E923AABF-CB58-4471-A119-FFFA01E4CE62}
MPC_GUID_ENTRY(MEDIASUBTYPE_ATRAC3plus,
			0xE923AABF, 0xCB58, 0x4471, 0xA1, 0x19, 0xFF, 0xFA, 0x01, 0xE4, 0xCE, 0x62)

// {4b4f4f43-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_COOK,
			0x4b4f4f43, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {54454e44-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_DNET,
			0x54454e44, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {52504953-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_SIPR,
			0x52504953, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {00000130-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_SIPR_WAVE,
			WAVE_FORMAT_SIPR, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {43414152-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_RAAC,
			0x43414152, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {50434152-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_RACP,
			0x50434152, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {464C4152-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_RALF,
			0x464C4152, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)


// QuickTime PCM

// {454E4F4E-0000-0010-8000-00AA00389B71} (unsigned 8-bit)
MPC_GUID_ENTRY(MEDIASUBTYPE_PCM_NONE,
			0x454E4F4E, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {20776172-0000-0010-8000-00AA00389B71} (unsigned 8-bit, signed big-endian 16 bit)
MPC_GUID_ENTRY(MEDIASUBTYPE_PCM_RAW,
			0x20776172, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {736f7774-0000-0010-8000-00AA00389B71} (signed 8-bit, signed big-endian 16-bit)
MPC_GUID_ENTRY(MEDIASUBTYPE_PCM_TWOS,
			0x736f7774, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {74776f73-0000-0010-8000-00AA00389B71} (signed 8-bit, signed little-endian 16-bit)
MPC_GUID_ENTRY(MEDIASUBTYPE_PCM_SOWT,
			0x74776f73, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {34326E69-0000-0010-8000-00AA00389B71} (signed big-endian int24)
MPC_GUID_ENTRY(MEDIASUBTYPE_PCM_IN24,
			0x34326E69, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {32336E69-0000-0010-8000-00AA00389B71} (signed big-endian int32)
MPC_GUID_ENTRY(MEDIASUBTYPE_PCM_IN32,
			0x32336E69, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {32336C66-0000-0010-8000-00AA00389B71} (signed big-endian float32)
MPC_GUID_ENTRY(MEDIASUBTYPE_PCM_FL32,
			0x32336C66, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {34366C66-0000-0010-8000-00AA00389B71} (signed big-endian float64)
MPC_GUID_ENTRY(MEDIASUBTYPE_PCM_FL64,
			0x34366C66, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// Reverse GUIDs for little-endian 'in24', 'in32', 'fl32', 'fl64'
// {696E3234-0000-0010-8000-00AA00389B71} (signed little-endian int24, reverse 'in24')
//MPC_GUID_ENTRY(MEDIASUBTYPE_PCM_IN24_le,
//			0x696E3234, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)
// {696E3332-0000-0010-8000-00AA00389B71} (signed little-endian int32, reverse 'in32')
//MPC_GUID_ENTRY(MEDIASUBTYPE_PCM_IN32_le,
//			0x696E3332, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)
// {666C3332-0000-0010-8000-00AA00389B71} (signed little-endian float32, reverse 'fl32')
//MPC_GUID_ENTRY(MEDIASUBTYPE_PCM_FL32_le,
//			0x666C3332, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)
// {666C3634-0000-0010-8000-00AA00389B71} (signed little-endian float64, reverse 'fl64')
//MPC_GUID_ENTRY(MEDIASUBTYPE_PCM_FL64_le,
//			0x666C3634, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)


// PS2

#define WAVE_FORMAT_PS2_PCM 0xF521
// {0000F521-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_PS2_PCM,
			WAVE_FORMAT_PS2_PCM, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

#define WAVE_FORMAT_PS2_ADPCM 0xF522
// {0000F522-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_PS2_ADPCM,
			WAVE_FORMAT_PS2_ADPCM, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

#define WAVE_FORMAT_ADPCM_SWF 0x5346
// {00005346-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_ADPCM_SWF,
			WAVE_FORMAT_ADPCM_SWF, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {4F3D3D21-6D7C-4f73-AA05-E397B5EAE0AA}
MPC_GUID_ENTRY(MEDIASUBTYPE_PS2_SUB,
			0x4f3d3d21, 0x6d7c, 0x4f73, 0xaa, 0x05, 0xe3, 0x97, 0xb5, 0xea, 0xe0, 0xaa)

#define WAVE_FORMAT_ADX_ADPCM 0x6153
// {78646153-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_ADX_ADPCM,
			0x78646153, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)


// Ogg

// {D2855FA9-61A7-4db0-B979-71F297C17A04}
MPC_GUID_ENTRY(MEDIASUBTYPE_Ogg,
			0xd2855fa9, 0x61a7, 0x4db0, 0xb9, 0x79, 0x71, 0xf2, 0x97, 0xc1, 0x7a, 0x4)

// {cddca2d5-6d75-4f98-840e-737bedd5c63b}
MPC_GUID_ENTRY(MEDIASUBTYPE_Vorbis,
			0xcddca2d5, 0x6d75, 0x4f98, 0x84, 0x0e, 0x73, 0x7b, 0xed, 0xd5, 0xc6, 0x3b)

// {6bddfa7e-9f22-46a9-ab5e-884eff294d9f}
MPC_GUID_ENTRY(FORMAT_VorbisFormat,
			0x6bddfa7e, 0x9f22, 0x46a9, 0xab, 0x5e, 0x88, 0x4e, 0xff, 0x29, 0x4d, 0x9f)

// {8D2FD10B-5841-4a6b-8905-588FEC1ADED9}
MPC_GUID_ENTRY(MEDIASUBTYPE_Vorbis2,
			0x8d2fd10b, 0x5841, 0x4a6b, 0x89, 0x05, 0x58, 0x8f, 0xec, 0x1a, 0xde, 0xd9)

// {B36E107F-A938-4387-93C7-55E966757473}
MPC_GUID_ENTRY(FORMAT_VorbisFormat2,
			0xb36e107f, 0xa938, 0x4387, 0x93, 0xc7, 0x55, 0xe9, 0x66, 0x75, 0x74, 0x73)


// Matroska

// {1AC0BEBD-4D2B-45ad-BCEB-F2C41C5E3788}
MPC_GUID_ENTRY(MEDIASUBTYPE_Matroska,
			0x1ac0bebd, 0x4d2b, 0x45ad, 0xbc, 0xeb, 0xf2, 0xc4, 0x1c, 0x5e, 0x37, 0x88)

// {E487EB08-6B26-4be9-9DD3-993434D313FD}
MPC_GUID_ENTRY(MEDIATYPE_Subtitle,
			0xe487eb08, 0x6b26, 0x4be9, 0x9d, 0xd3, 0x99, 0x34, 0x34, 0xd3, 0x13, 0xfd)

// {87C0B230-03A8-4fdf-8010-B27A5848200D}
MPC_GUID_ENTRY(MEDIASUBTYPE_UTF8,
			0x87c0b230, 0x03a8, 0x4fdf, 0x80, 0x10, 0xb2, 0x7a, 0x58, 0x48, 0x20, 0xd)

// {3020560F-255A-4ddc-806E-6C5CC6DCD70A}
MPC_GUID_ENTRY(MEDIASUBTYPE_SSA,
			0x3020560f, 0x255a, 0x4ddc, 0x80, 0x6e, 0x6c, 0x5c, 0xc6, 0xdc, 0xd7, 0xa)

// {326444F7-686F-47ff-A4B2-C8C96307B4C2}
MPC_GUID_ENTRY(MEDIASUBTYPE_ASS,
			0x326444f7, 0x686f, 0x47ff, 0xa4, 0xb2, 0xc8, 0xc9, 0x63, 0x07, 0xb4, 0xc2)

// {370689E7-B226-4f67-978D-F10BC1A9C6AE}
MPC_GUID_ENTRY(MEDIASUBTYPE_ASS2,
			0x370689e7, 0xb226, 0x4f67, 0x97, 0x8d, 0xf1, 0x0b, 0xc1, 0xa9, 0xc6, 0xae)

// {76C421C4-DB89-42ec-936E-A9FBC1794714}
MPC_GUID_ENTRY(MEDIASUBTYPE_SSF,
			0x76c421c4, 0xdb89, 0x42ec, 0x93, 0x6e, 0xa9, 0xfb, 0xc1, 0x79, 0x47, 0x14)

// {B753B29A-0A96-45be-985F-68351D9CAB90}
MPC_GUID_ENTRY(MEDIASUBTYPE_USF,
			0xb753b29a, 0x0a96, 0x45be, 0x98, 0x5f, 0x68, 0x35, 0x1d, 0x9c, 0xab, 0x90)

// {F7239E31-9599-4e43-8DD5-FBAF75CF37F1}
MPC_GUID_ENTRY(MEDIASUBTYPE_VOBSUB,
			0xf7239e31, 0x9599, 0x4e43, 0x8d, 0xd5, 0xfb, 0xaf, 0x75, 0xcf, 0x37, 0xf1)

// {A33D2F7D-96BC-4337-B23B-A8B9FBC295E9}
MPC_GUID_ENTRY(FORMAT_SubtitleInfo,
			0xa33d2f7d, 0x96bc, 0x4337, 0xb2, 0x3b, 0xa8, 0xb9, 0xfb, 0xc2, 0x95, 0xe9)

// {04EBA53E-9330-436c-9133-553EC87031DC}
MPC_GUID_ENTRY(MEDIASUBTYPE_HDMVSUB,
			0x04eba53e, 0x9330, 0x436c, 0x91, 0x33, 0x55, 0x3e, 0xc8, 0x70, 0x31, 0xdc)

// {42535844-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_XSUB,
			0x42535844, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// SUBTITLEINFO structure content starting at dwOffset (also the content of CodecPrivate)
// --------------------------------------------------------------------------------------
//
// Here the text should start with the Byte Order Mark, even though
// UTF-8 is prefered, it also helps identifying the encoding type.
//
// MEDIASUBTYPE_USF:
//
// <?xml version="1.0" encoding="UTF-8"?>
// <!-- DOCTYPE USFSubtitles SYSTEM "USFV100.dtd" -->
// <?xml-stylesheet type="text/xsl" href="USFV100.xsl"?>
//
// <USFSubtitles version="1.0">
// ... every element excluding <subtitles></subtitles> ...
// </USFSubtitles>
//
// MEDIASUBTYPE_SSA/ASS:
//
// The file header and all sub-sections except [Events]
//
// MEDIATYPE_VOBSUB:
//
// TODO
//

// Data description of the media samples (everything is UTF-8 encoded here)
// ------------------------------------------------------------------------
//
// MEDIASUBTYPE_USF:
//
// The text _inside_ the <subtitle>..</subtitle> element.
//
// Since timing is set on the sample, there is no need to put
// <subtitle start=".." stop=".." duration=".."> into the data.
//
// MEDIASUBTYPE_SSA/ASS:
//
// Comma separated values similar to the "Dialogue: ..." line with these fields:
// ReadOrder, Layer, Style, Name, MarginL, MarginR, MarginV, Effect, Text
//
// With the exception of ReadOrder every field can be found in ASS files. The
// ReadOrder field is needed for the decoder to be able to reorder the streamed
// samples as they were placed originally in the file.
//
// If the source is only SSA, the Layer field can be left empty.
//
// MEDIATYPE_VOBSUB:
//
// Standard dvd subpic data, without the stream id at the beginning.
//

// Matroska CodecID mappings
// ------------------------
//
// S_TEXT/ASCII	<->	MEDIATYPE_Text		MEDIASUBTYPE_NULL	FORMAT_None
// S_TEXT/UTF8	<->	MEDIATYPE_Subtitle	MEDIASUBTYPE_UTF8	FORMAT_SubtitleInfo
// S_TEXT/SSA	<->	MEDIATYPE_Subtitle	MEDIASUBTYPE_SSA	FORMAT_SubtitleInfo
// S_TEXT/ASS	<->	MEDIATYPE_Subtitle	MEDIASUBTYPE_ASS	FORMAT_SubtitleInfo
// S_TEXT/USF	<->	MEDIATYPE_Subtitle	MEDIASUBTYPE_USF	FORMAT_SubtitleInfo
// S_VOBSUB		<-> MEDIATYPE_Subtitle	MEDIASUBTYPE_VOBSUB	FORMAT_SubtitleInfo
// S_VOBSUB/ZLIB<-> MEDIATYPE_Subtitle	MEDIASUBTYPE_VOBSUB	FORMAT_SubtitleInfo
//

/*
MPC_GUID_ENTRY( MEDIATYPE_MPEG2_SECTIONS,
	0x455f176c, 0x4b06, 0x47ce, 0x9a, 0xef, 0x8c, 0xae, 0xf7, 0x3d, 0xf7, 0xb5)

MPC_GUID_ENTRY(MEDIASUBTYPE_ATSC_SI,
0xb3c7397c, 0xd303, 0x414d, 0xb3, 0x3c, 0x4e, 0xd2, 0xc9, 0xd2, 0x97, 0x33)

MPC_GUID_ENTRY(MEDIASUBTYPE_DVB_SI,
0xe9dd31a3, 0x221d, 0x4adb, 0x85, 0x32, 0x9a, 0xf3, 0x09, 0xc1, 0xa4, 0x8)


// {C892E55B-252D-42b5-A316-D997E7A5D995}
MPC_GUID_ENTRY(MEDIASUBTYPE_MPEG2DATA,
0xc892e55b, 0x252d, 0x42b5, 0xa3, 0x16, 0xd9, 0x97, 0xe7, 0xa5, 0xd9, 0x95)

*/

// H264
// 34363248-0000-0010-8000-00aa00389b71
// MPC_GUID_ENTRY(MEDIASUBTYPE_H264,
// 0x34363248, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {34363268-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_h264,
			0x34363268, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {34363258-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_X264,
			0x34363258, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {34363278-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_x264,
			0x34363278, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {6F29D2AD-E130-45AA-B42F-F623AD354A90}
MPC_GUID_ENTRY(MEDIASUBTYPE_ArcsoftH264,
			0x6F29D2AD, 0xE130, 0x45AA, 0xB4, 0x2F, 0xF6, 0x23, 0xAD, 0x35, 0x4A, 0x90)

// {48535356-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_VSSH,
			0x48535356, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {68737376-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_vssh,
			0x68737376, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {43564144-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_DAVC,
			0x43564144, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {63766164-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_davc,
			0x63766164, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {43564150-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_PAVC,
			0x43564150, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {63766170-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_pavc,
			0x63766170, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {31435641-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_AVC1,
			0x31435641, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {31637661-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_avc1,
			0x31637661, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {31564343-0000-0010-8000-00AA00389B71} (custom H.264 FourCC used by Haali Media Splitter)
MPC_GUID_ENTRY(MEDIASUBTYPE_CCV1,
			0x31564343, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {8D2D71CB-243F-45E3-B2D8-5FD7967EC09B} <= Used by MediaPortal for example...
MPC_GUID_ENTRY(MEDIASUBTYPE_H264_bis,
			0x8D2D71CB, 0x243F, 0x45E3, 0xB2, 0xD8, 0x5F, 0xD7, 0x96, 0x7E, 0xC0, 0x9B)

// {33515653-0000-0010-8000-00aa00389b71}
MPC_GUID_ENTRY(MEDIASUBTYPE_SVQ3,
			0x33515653, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {44495658-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_XVID,
			0x44495658, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {64697678-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_xvid,
			0x64697678, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {30355844-0000-0010-8000-00aa00389b71}
MPC_GUID_ENTRY(MEDIASUBTYPE_DX50,
			0x30355844, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {30357864-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_dx50,
			0x30357864, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {58564944-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_DIVX,
			0x58564944, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {78766964-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_divx,
			0x78766964, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {78766944-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_Divx,
			0x78766944, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {5634504d-0000-0010-8000-00aa00389b71}
MPC_GUID_ENTRY(MEDIASUBTYPE_MP4V,
			0x5634504d, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {7634706D-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_mp4v,
			0x7634706D, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {3253344d-0000-0010-8000-00aa00389b71}
MPC_GUID_ENTRY(MEDIASUBTYPE_M4S2,
			0x3253344d, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {3273346D-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_m4s2,
			0x3273346D, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {5334504D-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_MP4S,
			0x5334504D, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {7334706D-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_mp4s,
			0x7334706D, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {31564933-0000-0010-8000-00aa00389b71}
MPC_GUID_ENTRY(MEDIASUBTYPE_3IV1,
			0x31564933, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {31766933-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_3iv1,
			0x31766933, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {32564933-0000-0010-8000-00aa00389b71}
MPC_GUID_ENTRY(MEDIASUBTYPE_3IV2,
			0x32564933, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {32766933-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_3iv2,
			0x32766933, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {58564933-0000-0010-8000-00aa00389b71}
MPC_GUID_ENTRY(MEDIASUBTYPE_3IVX,
			0x58564933, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {78766933-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_3ivx,
			0x78766933, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {305A4C42-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_BLZ0,
			0x305A4C42, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {307A6C62-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_blz0,
			0x307A6C62, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {56344D44-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_DM4V,
			0x56344D44, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {76346D64-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_dm4v,
			0x76346D64, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {4D475844-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_DXGM,
			0x4D475844, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {6D677864-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_dxgm,
			0x6D677864, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {53444646-0000-0010-8000-00aa00389b71}
MPC_GUID_ENTRY(MEDIASUBTYPE_FFDS,
			0x53444646, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {73646666-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_ffds,
			0x73646666, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {57465646-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_FVFW,
			0x57465646, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {77667666-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_fvfw,
			0x77667666, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {34504D46-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_FMP4,
			0x34504D46, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {34706D66-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_fmp4,
			0x34706D66, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {34584448-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_HDX4,
			0x34584448, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {34786468-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_hdx4,
			0x34786468, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {34504D4C-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_LMP4,
			0x34504D4C, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {34706D6C-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_lmp4,
			0x34706D6C, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {4749444E-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_NDIG,
			0x4749444E, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {6769646E-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_ndig,
			0x6769646E, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {34504D52-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_RMP4,
			0x34504D52, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {34706D72-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_rmp4,
			0x34706D72, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {34504D53-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_SMP4,
			0x34504D53, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {34706D73-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_smp4,
			0x34706D73, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {47444553-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_SEDG,
			0x47444553, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {67646573-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_sedg,
			0x67646573, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {34504D55-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_UMP4,
			0x34504D55, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {34706D75-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_ump4,
			0x34706D75, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {46315657-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_WV1F,
			0x46315657, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {66317677-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_wv1f,
			0x66317677, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {58495658-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_XVIX,
			0x58495658, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {78697678-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_xvix,
			0x78697678, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {31564D57-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_WMV1,
			0x31564D57, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {31766D77-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_wmv1,
			0x31766D77, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {32564D57-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_WMV2,
			0x32564D57, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {32766D77-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_wmv2,
			0x32766D77, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {33564D57-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_WMV3,
			0x33564D57, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {33766D77-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_wmv3,
			0x33766D77, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {31515653-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_SVQ1,
			0x31515653, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {33363248-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_H263,
			0x33363248, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {33363268-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_h263,
			0x33363268, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {33363253-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_S263,
			0x33363253, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {33363273-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_s263,
			0x33363273, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {56564D41-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_AMVV,
			0x56564D41, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {31435657-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_WVC1,
			0x31435657, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {D979F77B-DBEA-4BF6-9E6D-1D7E57FBAD53}
MPC_GUID_ENTRY(MEDIASUBTYPE_WVC1_CYBERLINK,
			0xD979F77B, 0xDBEA, 0x4BF6, 0x9E, 0x6D, 0x1D, 0x7E, 0x57, 0xFB, 0xAD, 0x53)

// {629B40AD-AD74-4EF4-A985-F0C8D92E5ECA}
MPC_GUID_ENTRY(MEDIASUBTYPE_WVC1_ARCSOFT,
			0x629B40AD, 0xAD74, 0x4EF4, 0xA9, 0x85, 0xF0, 0xC8, 0xD9, 0x2E, 0x5E, 0xCA)

// {31637677-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_wvc1,
			0x31637677, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {3334504D-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_MP43,
			0x3334504D, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {3334706D-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_mp43,
			0x3334706D, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {33585644-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_DVX3,
			0x33585644, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {33787664-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_dvx3,
			0x33787664, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {33564944-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_DIV3,
			0x33564944, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {33766964-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_div3,
			0x33766964, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {314C4F43-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_COL1,
			0x314C4F43, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {316C6F63-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_col1,
			0x316C6F63, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {34564944-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_DIV4,
			0x34564944, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {34766964-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_div4,
			0x34766964, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {35564944-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_DIV5,
			0x35564944, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {35766964-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_div5,
			0x35766964, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {36564944-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_DIV6,
			0x36564944, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {36766964-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_div6,
			0x36766964, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {31345041-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_AP41,
			0x31345041, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {31347061-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_ap41,
			0x31347061, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {3347504D-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_MPG3,
			0x3347504D, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {3367706D-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_mpg3,
			0x3367706D, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {3234504D-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_MP42,
			0x3234504D, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {3234706D-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_mp42,
			0x3234706D, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {32564944-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_DIV2,
			0x32564944, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {32766964-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_div2,
			0x32766964, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {3447504D-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_MPG4,
			0x3447504D, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {3467706D-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_mpg4,
			0x3467706D, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {31564944-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_DIV1,
			0x31564944, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {31766964-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_div1,
			0x31766964, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {3134504D-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_MP41,
			0x3134504D, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {3134706D-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_mp41,
			0x3134706D, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {4F454854-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_THEORA,
			0x4F454854, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {6F656874-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_theora,
			0x6F656874, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {E69B30D1-7D65-4166-B990-103DA8C911E3}
MPC_GUID_ENTRY(FORMAT_RLTheora,
			0xe69b30d1, 0x7d65, 0x4166, 0xb9, 0x90, 0x10, 0x3d, 0xa8, 0xc9, 0x11, 0xe3)

// {63637374-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_TSCC,
			0x63637374, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {32637374-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_TSCC2,
			0x32637374, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {636E4D56-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_VMnc,
			0x636E4D56, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {3153534D-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_MSS1,
			0x3153534D, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {3253534D-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_MSS2,
			0x3253534D, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {3141534D-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_MSA1,
			0x3141534D, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {3253544D-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_MTS2,
			0x3253544D, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {324D3247-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_G2M2,
			0x324D3247, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {334D3247-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_G2M3,
			0x334D3247, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {344D3247-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_G2M4,
			0x344D3247, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {30355649-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_IV50,
			0x30355649, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {31345649-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_IV41,
			0x31345649, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {31335649-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_IV31,
			0x31335649, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {32335649-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_IV32,
			0x32335649, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {61706A6D-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_MJPA,
			0x61706A6D, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {62706A6D-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_MJPB,
			0x62706A6D, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {32706A6D-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_MJP2,
			0x32706A6D, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {43324A4D-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_MJ2C,
			0x43324A4D, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {44435343-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_CSCD,
			0x44435343, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// [55594648-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_HuffYUV,
			0x55594648, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {5347414C-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_Lagarith,
			0x5347414C, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {48564646-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_FFVH,
			0x48564646, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {31564646-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_FFV1,
			0x31564646, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {31565346-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_FLASHSV1,
			0x31565346, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {32565346-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_FLASHSV2,
			0x32565346, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {31535046-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_FPS1,
			0x31535046, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {694B4942-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_BINKVI,
			0x694B4942, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {624B4942-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_BINKVB,
			0x624B4942, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {31554142-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_BINKA_DCT,
			0x31554142, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {32554142-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_BINKA_RDFT,
			0x32554142, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {3267706D-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_MPG2,
			0x3267706D, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {47524C55-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_UTVD_ULRG, // UtVideo (ULRG fourcc, stands for RGB)
			0x47524C55, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {41524C55-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_UTVD_ULRA, // UtVideo (ULRA fourcc, stands for RGBA)
			0x41524C55, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {30594C55-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_UTVD_ULY0, // UtVideo (ULY0 fourcc, stands for YCbCr 4:2:0)
			0x30594C55, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {32594C55-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_UTVD_ULY2, // UtVideo (ULRG fourcc, stands for YCbCr 4:2:2)
			0x32594C55, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)


// Apple ProRes

// {68637061-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_apch,
			0x68637061, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {6e637061-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_apcn,
			0x6e637061, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {73637061-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_apcs,
			0x73637061, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {6f637061-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_apco,
			0x6f637061, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {68347061-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_ap4h,
			0x68347061, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {66706369-0000-0010-8000-00AA00389B71} // Apple ProRes in Matroska
MPC_GUID_ENTRY(MEDIASUBTYPE_icpf,
			0x66706369, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {6E645641-0000-0010-8000-00AA00389B71} Avid DNxHD
MPC_GUID_ENTRY(MEDIASUBTYPE_AVdn,
			0x6E645641, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {646F6369-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_icod,
			0x646F6369, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {64697663-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_CVID,
			0x64697663, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {48B93619-A959-45d9-B5FD-E12A67A96CF1}
MPC_GUID_ENTRY(MEDIASUBTYPE_RoQ,
			0x48b93619, 0xa959, 0x45d9, 0xb5, 0xfd, 0xe1, 0x2a, 0x67, 0xa9, 0x6c, 0xf1)

// {56516F52-0000-0010-8000-00AA00389B71} 'RoQV' == MEDIASUBTYPE_RoQV
MPC_GUID_ENTRY(MEDIASUBTYPE_RoQV,
			0x56516F52, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {20676e70-0000-0010-8000-00aa00389b71}
MPC_GUID_ENTRY(MEDIASUBTYPE_PNG,
			0x20676e70, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {53504238-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_8BPS,
			0x53504238, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {48564443-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_CDVH,
			0x48564443, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {43564443-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_CDVC,
			0x43564443, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// Quicktime DV sybtypes (used in LAV Splitter)
// {70637664-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_DVCP,
			0x70637664, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)
// {70707664-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_DVPP,
			0x70707664, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)
// {70357664-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_DV5P,
			0x70357664, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)
// {20637664-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_DVC,
			0x20637664, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// Audio codecs

// {41564D41-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_IMA_AMV,
			0x41564D41, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {4C4C454E-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_NELLYMOSER,
			0x4C4C454E, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {63616C61-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_ALAC,
			0x63616C61, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {20534C41-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_ALS,
			0x20534C41, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {324D4451-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_QDM2,
			0x324D4451, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {2043504D-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_MPC7,
			0x2043504D, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {3843504D-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_MPC8,
			0x3843504D, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {229F9AD7-2F4D-4b45-B858-A3F434E7179A}
MPC_GUID_ENTRY(MEDIASUBTYPE_MUSEPACK_Stream,
			0x229f9ad7, 0x2f4d, 0x4b45, 0xb8, 0x58, 0xa3, 0xf4, 0x34, 0xe7, 0x17, 0x9a)

// {FF5A7C6F-6646-42ab-A1FC-0E6739D56E75}
MPC_GUID_ENTRY(MEDIASUBTYPE_WAVPACK_Stream,
			0xff5a7c6f, 0x6646, 0x42ab, 0xa1, 0xfc, 0xe, 0x67, 0x39, 0xd5, 0x6e, 0x75)

// {A721EC57-6EEB-47a3-8805-AD75E0417C26}
MPC_GUID_ENTRY(MEDIASUBTYPE_TTA1_Stream,
			0xa721ec57, 0x6eeb, 0x47a3, 0x88, 0x05, 0xad, 0x75, 0xe0, 0x41, 0x7c, 0x26)

// {00000402-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_IAC,
			0x0402, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {00000401-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_IMC,
			0x0401, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

#define WAVE_FORMAT_RoQA 0x41516F52
// {41516F52-0000-0010-8000-00AA00389B71} 'RoQA' == MEDIASUBTYPE_RoQA
MPC_GUID_ENTRY(MEDIASUBTYPE_RoQA,
			WAVE_FORMAT_RoQA, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {20455041-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_APE,
			0x20455041, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {00000022-0000-0010-8000-00aa00389b71} DSP Group TrueSpeech
MPC_GUID_ENTRY(MEDIASUBTYPE_TRUESPEECH,
			0x00000022, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {00000075-0000-0010-8000-00aa00389b71} Voxware MetaSound
MPC_GUID_ENTRY(MEDIASUBTYPE_VOXWARE_RT29,
			0x00000075, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

#define WAVE_FORMAT_OPUS    0x504f
// {5355504F-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_OPUS,
			mmioFOURCC('O','P','U','S'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

#define WAVE_FORMAT_SPEEX   0xA109
// {0000A109-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_SPEEX,
			WAVE_FORMAT_SPEEX, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {949F97FD-56F6-4527-B4AE-DDEB375AB80F}   Mpc-be specific !
MPC_GUID_ENTRY(MEDIASUBTYPE_HDMV_LPCM_AUDIO,
			0x949f97fd, 0x56f6, 0x4527, 0xb4, 0xae, 0xdd, 0xeb, 0x37, 0x5a, 0xb8, 0xf)

// {20504C4D-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_MLP,
			mmioFOURCC('M','L','P',' '), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {20445344-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_DSD,
			mmioFOURCC('D','S','D',' '), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {4C445344-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_DSDL,
			mmioFOURCC('D','S','D','L'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {4D445344-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_DSDM,
			mmioFOURCC('D','S','D','M'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {31445344-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_DSD1,
			mmioFOURCC('D','S','D','1'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {38445344-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_DSD8,
			mmioFOURCC('D','S','D','8'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {AFBC2343-3DCB-4047-9655-E1E62A61B1C5}
MPC_GUID_ENTRY(MEDIASUBTYPE_FFMPEG_AUDIO,
			0xafbc2343, 0x3dcb, 0x4047, 0x96, 0x55, 0xe1, 0xe6, 0x2a, 0x61, 0xb1, 0xc5)

// {35189950-CAC9-4C8D-819D-B6FAEE15DD9D}
MPC_GUID_ENTRY(FORMAT_WaveFormatExFFMPEG,
			0x35189950, 0xcac9, 0x4c8d, 0x81, 0x9d, 0xb6, 0xfa, 0xee, 0x15, 0xdd, 0x9d)


// Guid from wmcodecdsp.h (Windows SDK)

// {0x30313456-0000-0010-8000-00aa00389b71}
MPC_GUID_ENTRY(MEDIASUBTYPE_V410,
			0x30313456, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {30313276-0000-0010-8000-00aa00389b71}
MPC_GUID_ENTRY(MEDIASUBTYPE_v210,
			0x30313276, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {30323449-0000-0010-8000-00aa00389b71}
MPC_GUID_ENTRY(MEDIASUBTYPE_I420,
			0x30323449, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {30313272-0000-0010-8000-00aa00389b71}
MPC_GUID_ENTRY(MEDIASUBTYPE_r210,
			0x30313272, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {67303152-0000-0010-8000-00AA00389B71
MPC_GUID_ENTRY(MEDIASUBTYPE_R10g,
			0x67303152, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {6B303152-0000-0010-8000-00aa00389b71}
MPC_GUID_ENTRY(MEDIASUBTYPE_R10k,
			0x6B303152, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {41564D57-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_WMVA,
			0x41564D57, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {50564D57-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_WMVP,
			0x50564D57, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {32505657-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_WVP2,
			0x32505657, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71)

// {000000FF-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_RAW_AAC1,
			0x000000FF, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {00002001-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_DTS2,
			0x00002001, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {A7FB87AF-2D02-42FB-A4D4-05CD93843BDD}
MPC_GUID_ENTRY(MEDIASUBTYPE_DOLBY_DDPLUS,
			0xa7fb87af, 0x2d02, 0x42fb, 0xa4, 0xd4, 0x05, 0xcd, 0x93, 0x84, 0x3b, 0xdd)

// {EB27CEC4-163E-4CA3-8B74-8E25F91B517E}
MPC_GUID_ENTRY(MEDIASUBTYPE_DOLBY_TRUEHD,
			0xeb27cec4, 0x163e, 0x4ca3, 0x8b, 0x74, 0x8e, 0x25, 0xf9, 0x1b, 0x51, 0x7e)

// {A2E58EB7-0FA9-48BB-A40C-FA0E156D0645}
MPC_GUID_ENTRY(MEDIASUBTYPE_DTS_HD,
			0xa2e58eb7, 0x0fa9, 0x48bb, 0xa4, 0x0c, 0xfa, 0x0e, 0x15, 0x6d, 0x06, 0x45)

// {00000160-0000-0010-8000-00aa00389b71} Windows Media Audio 1
MPC_GUID_ENTRY(MEDIASUBTYPE_MSAUDIO1,
			0x00000160, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {00000161-0000-0010-8000-00AA00389B71} Windows Media Audio 2 (WMAudioV2, WMAudioV7, WMAudioV8)
MPC_GUID_ENTRY(MEDIASUBTYPE_WMAUDIO2,
			0x00000161, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {00000162-0000-0010-8000-00aa00389b71} Windows Media Audio 9 Professional
MPC_GUID_ENTRY(MEDIASUBTYPE_WMAUDIO3,
			0x00000162, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {00000163-0000-0010-8000-00aa00389b71} Windows Media Audio Lossless
MPC_GUID_ENTRY(MEDIASUBTYPE_WMAUDIO_LOSSLESS,
			0x00000163, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {0000000A-0000-0010-8000-00AA00389B71} Windows Media Audio Voice
MPC_GUID_ENTRY(MEDIASUBTYPE_WMSP1,
			0x0000000A, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// Guid from encdec.h (Windows SDK)

// {46adbd28-6fd0-4796-93b2-155c51dc048d}
MPC_GUID_ENTRY(MEDIASUBTYPE_CPFilters_Processed,
			0x46adbd28, 0x6fd0, 0x4796, 0x93, 0xb2, 0x15, 0x5c, 0x51, 0xdc, 0x4, 0x8d )

// {6739b36f-1d5f-4ac2-8192-28bb0e73d16a}
MPC_GUID_ENTRY(FORMATTYPE_CPFilters_Processed,
			0x6739b36f, 0x1d5f, 0x4ac2, 0x81, 0x92, 0x28, 0xbb, 0xe, 0x73, 0xd1, 0x6a )


// Additionnal DXVA GUIDs

// {BCC5DB6D-A2B6-4AF0-ACE4-ADB1F787BC89} Intel ClearVideo VC1 bitstream decoder
MPC_GUID_ENTRY(DXVA_Intel_VC1_ClearVideo,
			0xBCC5DB6D, 0xA2B6, 0x4AF0, 0xAC, 0xE4, 0xAD, 0xB1, 0xF7, 0x87, 0xBC, 0x89)

// {E07EC519-E651-4CD6-AC84-1370CCEEC851}
MPC_GUID_ENTRY(DXVA_Intel_VC1_ClearVideo_2,
			0xE07EC519, 0xE651, 0x4CD6, 0xAC, 0x84, 0x13, 0x70, 0xCC, 0xEE, 0xC8, 0x51)

// {604F8E68-4951-4C54-88FE-ABD25C15B3D6} Intel ClearVideo H264 bitstream decoder
MPC_GUID_ENTRY(DXVA_Intel_H264_ClearVideo,
			0x604F8E68, 0x4951, 0x4C54, 0x88, 0xFE, 0xAB, 0xD2, 0x5C, 0x15, 0xB3, 0xD6)

// {9947EC6F-689B-11DC-A320-0019DBBC4184} Nvidia MPEG-4 ASP bitstream decoder
MPC_GUID_ENTRY(DXVA_MPEG4_ASP,
			0x9947EC6F, 0x689B, 0x11DC, 0xA3, 0x20, 0x00, 0x19, 0xDB, 0xBC, 0x41, 0x84)

// {4245F676-2BBC-4166-A0BB-54E7B849C380} ModeH264_VLD_NoFGT_Flash bitstream decoder
MPC_GUID_ENTRY(DXVA2_ModeH264_Flash,
			0x4245F676, 0x2BBC, 0x4166, 0xA0, 0xBB, 0x54, 0xE7, 0xB8, 0x49, 0xC3, 0x80)

// {1B81BEA4-A0C7-11D3-B984-00C04F2E73C5} Conformity to the August 2010 update of the specification, ModeVC1_VLD2010
MPC_GUID_ENTRY(DXVA2_ModeVC1_D2010,
			0x1b81beA4, 0xa0c7, 0x11d3, 0xb9, 0x84, 0x00, 0xc0, 0x4f, 0x2e, 0x73, 0xc5)

// {86695F12-340E-4f04-9FD3-9253DD327460}
MPC_GUID_ENTRY(DXVA_ModeMPEG2and1_VLD,
			0x86695f12, 0x340e, 0x4f04, 0x9f, 0xd3, 0x92, 0x53, 0xdd, 0x32, 0x74, 0x60)

// HEVC
MPC_GUID_ENTRY(DXVA_ModeHEVC_VLD_Main,
			0x5b11d51b, 0x2f4c, 0x4452, 0xbc, 0xc3, 0x9, 0xf2, 0xa1, 0x16, 0xc, 0xc0)
MPC_GUID_ENTRY(DXVA_ModeHEVC_VLD_Main10,
			0x107af0e0, 0xef1a, 0x4d19, 0xab, 0xa8, 0x67, 0xa1, 0x63, 0x7, 0x3d, 0x13)

// uncompressed

// {30303859-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_Y800,
			0x30303859, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {36315659-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_YV16,
			0x36315659, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {34325659-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_YV24,
			0x34325659, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {30313459-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_Y410,
			0x30313459, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {36313459-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_Y416,
			0x36313459, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {42313459-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_Y41B, // YUV 4:1:1 Planar
			0x42313459, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {42323459-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_Y42B, // YUV 4:2:2 Planar
			0x42323459, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {50343434-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_444P, // YUV 4:4:4 Planar
			0x50343434, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {76757963-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_cyuv, // UYVY flipped vertically
			0x76757963, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// {32767579-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_yuv2, // modified YUY2, used in QuickTime
			0x32767579, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)


// {D80FA03C-35C1-4FA1-8C8E-375C8667166E}
MPC_GUID_ENTRY(MEDIASUBTYPE_LAV_RAWVIDEO,
			0xd80fa03c, 0x35c1, 0x4fa1, 0x8c, 0x8e, 0x37, 0x5c, 0x86, 0x67, 0x16, 0x6e)


// {20C518C0-C136-4FB8-8418-024934F0BACA}
MPC_GUID_ENTRY(MEDIASUBTYPE_TAK_Stream,
			0x20c518c0, 0xc136, 0x4fb8, 0x84, 0x18, 0x02, 0x49, 0x34, 0xf0, 0xba, 0xca)

// {4D415243-0000-0010-8000-00AA00389B71}
MPC_GUID_ENTRY(MEDIASUBTYPE_CRAM,
			0x4D415243, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)


////////////////////////////////////////////////////////////////////////////////////////
// CLSID of some filters

// Ogg
// {F07E245F-5A1F-4d1e-8BFF-DC31D84A55AB}
MPC_GUID_ENTRY(CLSID_OggSplitter,
			0xf07e245f, 0x5a1f, 0x4d1e, 0x8b, 0xff, 0xdc, 0x31, 0xd8, 0x4a, 0x55, 0xab)
// {078C3DAA-9E58-4d42-9E1C-7C8EE79539C5}
MPC_GUID_ENTRY(CLSID_OggSplitPropPage,
			0x078c3daa, 0x9e58, 0x4d42, 0x9e, 0x1c, 0x7c, 0x8e, 0xe7, 0x95, 0x39, 0xc5)
// {8CAE96B7-85B1-4605-B23C-17FF5262B296}
MPC_GUID_ENTRY(CLSID_OggMux,
			0x8cae96b7, 0x85b1, 0x4605, 0xb2, 0x3c, 0x17, 0xff, 0x52, 0x62, 0xb2, 0x96)
// {AB97AFC3-D08E-4e2d-98E0-AEE6D4634BA4}
MPC_GUID_ENTRY(CLSID_OggMuxPropPage,
			0xab97afc3, 0xd08e, 0x4e2d, 0x98, 0xe0, 0xae, 0xe6, 0xd4, 0x63, 0x4b, 0xa4)
// {889EF574-0656-4b52-9091-072E52BB1B80}
MPC_GUID_ENTRY(CLSID_VorbisEnc,
			0x889ef574, 0x0656, 0x4b52, 0x90, 0x91, 0x07, 0x2e, 0x52, 0xbb, 0x1b, 0x80)
// {c5379125-fd36-4277-a7cd-fab469ef3a2f}
MPC_GUID_ENTRY(CLSID_VorbisEncPropPage,
			0xc5379125, 0xfd36, 0x4277, 0xa7, 0xcd, 0xfa, 0xb4, 0x69, 0xef, 0x3a, 0x2f)
// {02391f44-2767-4e6a-a484-9b47b506f3a4}
MPC_GUID_ENTRY(CLSID_VorbisDec,
			0x02391f44, 0x2767, 0x4e6a, 0xa4, 0x84, 0x9b, 0x47, 0xb5, 0x06, 0xf3, 0xa4)
// {77983549-ffda-4a88-b48f-b924e8d1f01c}
MPC_GUID_ENTRY(CLSID_OggDSAboutPage,
			0x77983549, 0xffda, 0x4a88, 0xb4, 0x8f, 0xb9, 0x24, 0xe8, 0xd1, 0xf0, 0x1c)

// sources and splitters
// {6B6D0800-9ADA-11d0-A520-00A0D10129C0}
MPC_GUID_ENTRY(CLSID_NetShowSource,
			0x6b6d0800, 0x9ada, 0x11d0, 0xa5, 0x20, 0x00, 0xa0, 0xd1, 0x01, 0x29, 0xc0)
// {564FD788-86C9-4444-971E-CC4A243DA150} Haali Splitter (AR)
MPC_GUID_ENTRY(CLSID_HaaliSplitterAR,
			0x564FD788, 0x86C9, 0x4444, 0x97, 0x1E, 0xCC, 0x4A, 0x24, 0x3D, 0xA1, 0x50)
// {55DA30FC-F16B-49FC-BAA5-AE59FC65F82D} Haali Splitter
MPC_GUID_ENTRY(CLSID_HaaliSplitter,
			0x55DA30FC, 0xF16B, 0x49FC, 0xBA, 0xA5, 0xAE, 0x59, 0xFC, 0x65, 0xF8, 0x2D)
// {171252A0-8820-4AFE-9DF8-5C92B2D66B04} LAV Splitter
MPC_GUID_ENTRY(CLSID_LAVSplitter,
			0x171252A0, 0x8820, 0x4AFE, 0x9D, 0xF8, 0x5C, 0x92, 0xB2, 0xD6, 0x6B, 0x04)
// {B98D13E7-55DB-4385-A33D-09FD1BA26338} LAV Source
MPC_GUID_ENTRY(CLSID_LAVSource,
			0xB98D13E7, 0x55DB, 0x4385, 0xA3, 0x3D, 0x09, 0xFD, 0x1B, 0xA2, 0x63, 0x38)

// video decoders
// {212690FB-83E5-4526-8FD7-74478B7939CD} from wmcodecdsp.h
MPC_GUID_ENTRY(CLSID_CMPEG2VidDecoderDS,
			0x212690FB, 0x83E5, 0x4526, 0x8F, 0xD7, 0x74, 0x47, 0x8B, 0x79, 0x39, 0xCD)
// {71E4616A-DB5E-452B-8CA5-71D9CC7805E9} - Nvidia VideoDecoder
MPC_GUID_ENTRY(CLSID_NvidiaVideoDecoder,
			0x71E4616A, 0xDB5E, 0x452B, 0x8C, 0xA5, 0x71, 0xD9, 0xCC, 0x78, 0x05, 0xE9)
// {D7D50E8D-DD72-43C2-8587-A0C197D837D2} - Sonic Cinemaster VideoDecoder
MPC_GUID_ENTRY(CLSID_SonicCinemasterVideoDecoder,
			0xD7D50E8D, 0xDD72, 0x43C2, 0x85, 0x87, 0xA0, 0xC1, 0x97, 0xD8, 0x37, 0xD2)

// allocator presenters
// {495CF191-810D-44c7-92C5-E7D46AE00F44}
MPC_GUID_ENTRY(CLSID_VMR7AllocatorPresenter,
			0x495cf191, 0x810d, 0x44c7, 0x92, 0xc5, 0xe7, 0xd4, 0x6a, 0xe0, 0x0f, 0x44)
// {97B3462E-1752-4dfb-A038-271060BC7A94}
MPC_GUID_ENTRY(CLSID_RM7AllocatorPresenter,
			0x97b3462e, 0x1752, 0x4dfb, 0xa0, 0x38, 0x27, 0x10, 0x60, 0xbc, 0x7a, 0x94)
// {36CC5A71-441C-462a-9D10-48A19485938D}
MPC_GUID_ENTRY(CLSID_QT7AllocatorPresenter,
			0x36cc5a71, 0x441c, 0x462a, 0x9d, 0x10, 0x48, 0xa1, 0x94, 0x85, 0x93, 0x8d)
// {4E4834FA-22C2-40e2-9446-F77DD05D245E}
MPC_GUID_ENTRY(CLSID_VMR9AllocatorPresenter,
			0x4e4834fa, 0x22c2, 0x40e2, 0x94, 0x46, 0xf7, 0x7d, 0xd0, 0x5d, 0x24, 0x5e)
// {7612b889-e070-4bcc-0b88-91cb794174ab}
MPC_GUID_ENTRY(CLSID_EVRAllocatorPresenter,
			0x7612b889, 0xe070, 0x4bcc, 0xb8, 0x08, 0x91, 0xcb, 0x79, 0x41, 0x74, 0xab)
// {F9F62627-E3EF-4a2e-B6C9-5D4C0DC3326B}
MPC_GUID_ENTRY(CLSID_SyncAllocatorPresenter,
			0xf9f62627, 0xe3ef, 0x4a2e, 0xb6, 0xc9, 0x5d, 0x4c, 0x0d, 0xc3, 0x32, 0x6b)
// {B72EBDD4-831D-440f-A656-B48F5486CD82}
MPC_GUID_ENTRY(CLSID_DXRAllocatorPresenter,
			0xb72ebdd4, 0x831d, 0x440f, 0xa6, 0x56, 0xb4, 0x8f, 0x54, 0x86, 0xcd, 0x82)
// {C7ED3100-9002-4595-9DCA-B30B30413429}
MPC_GUID_ENTRY(CLSID_madVRAllocatorPresenter,
			0xc7ed3100, 0x9002, 0x4595, 0x9d, 0xca, 0xb3, 0x0b, 0x30, 0x41, 0x34, 0x29)

// video renderers
// {760A8F35-97E7-479d-AAF5-DA9EFF95D751} Haali's video renderer
MPC_GUID_ENTRY(CLSID_DXR,
			0x760a8f35, 0x97e7, 0x479d, 0xaa, 0xf5, 0xda, 0x9e, 0xff, 0x95, 0xd7, 0x51)
// {E1A8B82A-32CE-4B0D-BE0D-AA68C772E423} madVR
MPC_GUID_ENTRY(CLSID_madVR,
			0xe1a8b82a, 0x32ce, 0x4b0d, 0xbe, 0x0d, 0xaa, 0x68, 0xc7, 0x72, 0xe4, 0x23)

// audio renderers
// {601D2A2B-9CDE-40bd-8650-0485E3522727} - MPC Audio Renderer(WASAPI)
MPC_GUID_ENTRY(CLSID_MpcAudioRenderer,
			0x601d2a2b, 0x9cde, 0x40bd, 0x86, 0x50, 0x04, 0x85, 0xe3, 0x52, 0x27, 0x27)
// {9DC15360-914C-46B8-B9DF-BFE67FD36C6A} - ReClock
MPC_GUID_ENTRY(CLSID_ReClock,
			0x9dc15360, 0x914c, 0x46b8, 0xb9, 0xdf, 0xbf, 0xe6, 0x7f, 0xd3, 0x6c, 0x6a)
// {EC9ED6FC-7B03-4cb6-8C01-4EABE109F26B} - MediaPortal Audio Renderer
MPC_GUID_ENTRY(CLSID_MPAudioRenderer,
			0xEC9ED6FC, 0x7B03, 0x4cb6, 0x8C, 0x01, 0x4E, 0xAB, 0xE1, 0x09, 0xF2, 0x6B)

// other filters
// {AB9D6472-752F-43F6-B29E-61207BDA8E06} - RDP Redirection Filter
MPC_GUID_ENTRY(CLSID_RDPDShowRedirectionFilter,
			0xAB9D6472, 0x752F, 0x43F6, 0xB2, 0x9E, 0x61, 0x20, 0x7B, 0xDA, 0x8E, 0x06)
// {D3CD7858-971A-4838-ACEC-40CA5D529DC8} - Morgan's Stream Switcher
MPC_GUID_ENTRY(CLSID_MorganSwitcher,
			0xD3CD7858, 0x971A, 0x4838, 0xAC, 0xEC, 0x40, 0xCA, 0x5D, 0x52, 0x9D, 0xC8)
// {482d10b6-376e-4411-8a17-833800A065DB}" XEB Navigation Filter (RatDVD)
MPC_GUID_ENTRY(CLSID_RatDVDNavigator,
			0x482d10b6, 0x376e, 0x4411, 0x8a, 0x17, 0x83, 0x38, 0x00, 0xA0, 0x65, 0xDB)

// {93A22E7A-5091-45EF-BA61-6DA26156A5D0}  DirectVobSub/VSFilter
MPC_GUID_ENTRY(CLSID_VSFilter,
			0x93A22E7A, 0x5091, 0x45EF, 0xBA, 0x61, 0x6D, 0xA2, 0x61, 0x56, 0xA5, 0xD0)
// {9852A670-F845-491B-9BE6-EBD841B8A613} DirectVobSub/VSFilter (auto-loading version)
MPC_GUID_ENTRY(CLSID_VSFilter_autoloading,
			0x9852A670, 0xF845, 0x491B, 0x9B, 0xE6, 0xEB, 0xD8, 0x41, 0xB8, 0xA6, 0x13)
// {2DFCB782-EC20-4A7C-B530-4577ADB33F21} XySubFilter
MPC_GUID_ENTRY(CLSID_XySubFilter,
			0x2DFCB782, 0xEC20, 0x4A7C, 0xB5, 0x30, 0x45, 0x77, 0xAD, 0xB3, 0x3F, 0x21)
// {6B237877-902B-4C6C-92F6-E63169A5166C} XySubFilterAutoLoader
MPC_GUID_ENTRY(CLSID_XySubFilter_AutoLoader,
			0x6B237877, 0x902B, 0x4C6C, 0x92, 0xF6, 0xE6, 0x31, 0x69, 0xA5, 0x16, 0x6C)
